#include <iostream>
#include <vector>
#include <iomanip>
#include <string>
#include "board.h"
#include "utils.h"
#include "bits.h"
#include "material.h"
#include "log.h"


using namespace std;

cBoard::cBoard()
{
   ;
}

void cBoard::clearboard()
{
    for(uint i = 0; i < BRDSQ; ++i)
    {
        board[i] = pE;
    }
    side = cN;
    enpas = NOSQ;
    fifty = 0;
    castleperm = 0;
}

void cBoard::printboard()
{
    uint f = 0;
    int  r = 0;
    uint sq;

    cout<<endl;

    for( r = 7; r>=0; r--)
    {
        for( f = 0; f<=7; ++f)
        {
           sq = fr2sq(f,r);
           ASS(onbrd(sq));
           cout<<setw(3)<<piecechar(board[sq]);
        }
        cout<<endl;
    }
    cout<<endl<<"castle ";

    if(castleperm & WCAKS) cout<<"K"; else cout<<"-";
    if(castleperm & WCAQS) cout<<"Q"; else cout<<"-";
    if(castleperm & BCAKS) cout<<"k"; else cout<<"-";
    if(castleperm & BCAQS) cout<<"q"; else cout<<"-";
    cout<<endl;

    cout<<"\n key "<<key;
    cout<<"\n pawnkey "<<pawnkey;
    cout<<"\n side "<<side;
    cout<<" enpas "<<enpas;
	if(onbrd(enpas)) cout<<"("<<printsquare(enpas)<<")";
    cout<<" fifty "<<fifty;
    cout<<" ply "<<ply;
}


void cBoard::logboard()
{
    if(logger.islog()==false) return;
    uint f = 0;
    int  r = 0;
    uint sq;

    logger.file<<endl;

    for( r = 7; r>=0; r--)
    {
        for( f = 0; f<=7; ++f)
        {
           sq = fr2sq(f,r);
           ASS(onbrd(sq));
           logger.file<<setw(3)<<piecechar(board[sq]);
        }
        logger.file<<endl;
    }
    logger.file<<endl<<"castle ";

    if(castleperm & WCAKS) logger.file<<"K"; else logger.file<<"-";
    if(castleperm & WCAQS) logger.file<<"Q"; else logger.file<<"-";
    if(castleperm & BCAKS) logger.file<<"k"; else logger.file<<"-";
    if(castleperm & BCAQS) logger.file<<"q"; else logger.file<<"-";
    logger.file<<endl;

    logger.file<<"\n key "<<key;
    logger.file<<"\n pawnkey "<<pawnkey;
    logger.file<<"\n side "<<side;
    logger.file<<" enpas "<<enpas;
	if(onbrd(enpas)) logger.file<<"("<<printsquare(enpas)<<")";
    logger.file<<" fifty "<<fifty;
    logger.file<<" ply "<<ply;
    logger.file<<endl;
}

void cBoard::setside(const uint s)
{
    ASS(sideok(s));
    side = s;
}
void cBoard::setfifty(const uint f)
{
    ASS(fiftyok(f));
    fifty = f;
}

void cBoard::resetfifty()
{
    fifty = 0;
}
void cBoard::setcastle(const uint c)
{
    ASS(castleok(c));
    castleperm |= c;
}
void cBoard::setenpas(const uint s)
{
    ASS(enpasok(s));
    enpas = s;
}
void cBoard::setpiece(const uint p, const uint s)
{
    ASS(piecegood(p));
    ASS(onbrd(s));
    board[s] = p;
}
void cBoard::setkey(const u64 k)
{
    key = k;
}
void cBoard::setpawnkey(const u64 k)
{
    pawnkey = k;
}


bool position_check(cBoard &b,  cMaterial &m)
{
	//hash keys
	if(!checkkey(b))
	{
		cout<<"\n hash key error "; return false;
	}

	//side
	if(b.getside( ) != cW && b.getside( ) != cB)
	{
		cout<<"\n side error "; return false;
	}
/*
	//side not moving in check?
	if(isattacked(p->p2sq[p->side^1][1], p->side))
	{
		cout<<"\n king capture error "; return false;
	}
*/
	//material
	uint sq, index;
	uint pcecol;
	uint pce;
	uint btot = 0, wtot = 0;

	uint wm = 0,bm = 0;
	uint num[numpieces] = {0,0,0,0,0,0,0,0,0,0,0,0,0};
	uint wp = 0, bp = 0;
	uint wmaj = 0, bmaj = 0;
	uint wmin = 0, bmin = 0;
	uint wbig = 0, bbig = 0;
	uint wksq = 0;
	uint bksq = 0;

	u64 wPbb = 0;
	u64 bPbb = 0;
	int psqopen[2] = {0,0};
	int psqend[2] = {0,0};
    for (index = 0; index < 64; ++index)
    {
         sq = sqfrom64(index);
         ASS(onbrd(sq));
         pce = b.getpiece(sq);

         if(pce == pE) continue;

         pcecol = pcecolour(pce);

         ASS(colourgood(pcecol));
         ASS(piecegood(pce));

         psqopen[pcecol]+= m.getpsqt(OPE, pce, sq);
         psqend[pcecol]+= m.getpsqt(END, pce, sq);

         switch(pce)
			 {
			 case pwP:wtot++; wm += piecevals[pwP];num[pwP]++;wp++; setbit(sq, wPbb);break;
			 case pwN:wtot++; wm += piecevals[pwN];num[pwN]++;wmin++;wbig++;break;
			 case pwB:wtot++; wm += piecevals[pwB];num[pwB]++;wmin++;wbig++;break;
			 case pwR:wtot++; wm += piecevals[pwR];num[pwR]++;wmaj++;wbig++;break;
			 case pwQ:wtot++; wm += piecevals[pwQ];num[pwQ]++;wmaj++;wbig++;break;
			 case pwK:wtot++; num[pwK]++; wksq = sq;break;
			 case pbP:btot++; bm += piecevals[pbP];num[pbP]++;bp++;setbit(sq, bPbb);break;
			 case pbN:btot++; bm += piecevals[pbN];num[pbN]++;bmin++;bbig++;break;
			 case pbB:btot++; bm += piecevals[pbB];num[pbB]++;bmin++;bbig++;break;
			 case pbR:btot++; bm += piecevals[pbR];num[pbR]++;bmaj++;bbig++;break;
			 case pbQ:btot++; bm += piecevals[pbQ];num[pbQ]++;bmaj++;bbig++;break;
			 case pbK:btot++; num[pbK]++; bksq = sq;break;
			 default: cout<<"\n piece not known"; return false; break;
			 };
    }
 	//now check material counts and king position
	if(b.getpiece(wksq) != pwK) {cout<<"\n wking false "; return false;}
	if(b.getpiece(bksq) != pbK) {cout<<"\n bking false "; return false;}
	if(num[pbK]!=1 || num[pwK]!=1){cout<<"\n king count false "; return false;}
	if(m.getmaterial(cW) != wm) {cout<<"\n wmaterial false "; return false;}
	if(m.getmaterial(cB)  != bm)
	{
	    {cout<<"\n bmaterial false "; m.printmaterial();return false;}
    }
    if(m.getpsqvalope() != psqopen[cW]-psqopen[cB]) {cout<<"\n Psqope false "; return false;}
    if(m.getpsqvalend() != psqend[cW]-psqend[cB]) {cout<<"\n Psqend false "; return false;}
	if(m.getpcenum(pwP) != num[pwP]) {cout<<"\n wPnum false "; return false;}
	if(m.getpcenum(pwN)  != num[pwN]) {cout<<"\n wNnum false "; return false;}
	if(m.getpcenum(pwB)  != num[pwB]) {cout<<"\n wBnum false "; return false;}
	if(m.getpcenum(pwR)  != num[pwR]) {cout<<"\n wRnum false "; return false;}
	if(m.getpcenum(pwQ) != num[pwQ]) {cout<<"\n wQnum false "; return false;}
	if(m.getpcenum(pbP) != num[pbP]) {cout<<"\n bPnum false "; return false;}
	if(m.getpcenum(pbN)  != num[pbN]) {cout<<"\n bNnum false "; return false;}
	if(m.getpcenum(pbB) != num[pbB]) {cout<<"\n bBnum false "; return false;}
	if(m.getpcenum(pbR) != num[pbR]) {cout<<"\n bRnum false "; return false;}
	if(m.getpcenum(pbQ) != num[pbQ]) {cout<<"\n bQnum false "; return false;}
	if(wPbb != m.getboard(pwP))
	{cout<<"\n wPboard false "; return false;}
	if(bPbb != m.getboard(pbP))
	{cout<<"\n bPboard false "; printbitboard(bPbb);printbitboard(m.getboard(pbP));return false;}

	/*if(m.getmajors(cW) != wmaj) {cout<<"\n wmaj false "; return false;}
	if(m.getmajors(cB) != bmaj) {cout<<"\n bmaj false "; return false;}
	if(m.getminors(cW) != wmin) {cout<<"\n wmin false "; return false;}
	if(m.getminors(cB) != bmin) {cout<<"\n bmin false "; return false;}*/
	if(m.getbigpieces(cW) != wbig) {cout<<"\n wbig false "; return false;}
	if(m.getbigpieces(cB) != bbig) {cout<<"\n bbig false "; return false;}

                //piece list check
                uint index2;
                for(index = pwP; index <= pbK; ++index)
                {
                    if(m.getpcenum(index) !=  num[index] )
                    {
                       cout<<"\nnumber false\n";
                       cout<<" piece "<<piecechars[index];
                       cout<<"\n m.getpcenum(index) = "<<m.getpcenum(index);
                       cout<<"\n num[index]         = "<<num[index];
                       return false;
                    }
                    for(index2 = 1; index2 <= m.getpcenum(index); ++index2)
                    {
                            sq = m.getpcesq(index,index2);
                            if(b.getpiece(sq) != index)
                            {
                              m.printmaterial();
                              b.printboard();
                              cout<<"\n piece "<<piecechars[index];
                              cout<<" square "<<printsquare(sq);
                             cout<<"\npiece false\n";
                             return false;
                            }
                    }
                }

   return true;
}

//not members of the board class.... to prevent confusion
u64 genhashkey(cBoard &b)
{
    u64 newkey = 0;
    uint i;
    uint sq;
    uint piece;

    for(i = 0; i < 64; ++i)
    {
        sq=sqfrom64(i);
        piece = b.getpiece(sq);
        ASS(piecegood(piece));
        ASS(onbrd(sq));
        if(piece != pE) newkey ^= piece_hash_keys[piece][sq];
    }

    ASS(castleok(b.getcastle()));
    ASS(sideok(b.getside()));
    ASS(enpasok(b.getenpas()));

    newkey ^= castle_hash_keys[b.getcastle()];
    newkey ^= side_hash_keys[b.getside()];
    newkey ^= enpas_hash_keys[b.getenpas()];

    return newkey;
}

bool checkkey(cBoard &b)
{
    u64 check = genhashkey(b);
    if(check!=b.getkey())
    {
        cout<<"\n real key = "<<check;
        cout<<" key fail !!";
        return false;
    }
    check = genpawnkey(b);
    if(check!=b.getpawnkey())
    {
        cout<<"\n real pawn key = "<<check;
        cout<<" pawn key fail !!";
        return false;
    }
    return true;
}

u64 genpawnkey(cBoard &b)
{
    u64 newkey = 0;
    uint i;
    uint sq;
    uint piece;

    for(i = 0; i < 64; ++i)
    {
        sq=sqfrom64(i);
        piece = b.getpiece(sq);
        ASS(piecegood(piece));
        ASS(onbrd(sq));
        if(piece == pwP || piece == pbP)
        newkey ^= piece_hash_keys[piece][sq];
    }

    return newkey;
}

